---------------------- MODULE LivePhilo1 ----------------------
EXTENDS Naturals, TLC
VARIABLES e, h, t, p 

CONSTANT ProcSet



Pini == p \in {0,1}
ERange == /\ e \in [{0,1} -> BOOLEAN]
          /\ h \in [{0,1} -> BOOLEAN]
          /\ t \in [{0,1} -> BOOLEAN]


Eini(i) == (e[i] => p=i)
AllPhiloIni == /\ Pini
               /\ \A i \in ProcSet: Eini(i)

OneState(i) == (e[i] \/ h[i] \/ t[i])

MutexSt(i) == \neg \/ (e[i] /\ h[i])
                   \/ (e[i] /\ t[i])
                   \/ (t[i] /\ h[i])
 
NxtSt(s,i,val) == (s' = [s EXCEPT ![i] = val])
 
CoEat(i) == /\ e[i] 
            /\ \/ NxtSt(t,i,TRUE)  /\ NxtSt(e,i,FALSE)
               \/ UNCHANGED<<e,t>>
            /\ UNCHANGED<<h,p>>
            (* /\ Print("Go to Eat",TRUE)*)

CoThink(i) == /\ t[i] 
              /\ \/ NxtSt(h,i,TRUE) /\ NxtSt(t,i,FALSE)
                 \/ UNCHANGED<<h,t>>
	      /\ UNCHANGED<<e,p>>

CoHungry(i) == /\ h[i]
               /\ p = i
               /\ \/ NxtSt(e,i,TRUE) /\ NxtSt(h,i,FALSE)
                  \/ UNCHANGED<<h,e>>
               /\ UNCHANGED<<t,p>>

Starve(i) == /\ h[i] 
             /\ p # i 
             /\ UNCHANGED<<h,e,p,t>>

TokenKeep(i) ==  /\ (p = i) 
                 /\ \/ (p' \in ProcSet ) /\ NxtSt(e,i,FALSE)
                    \/ UNCHANGED<<e,p>>
                 /\ UNCHANGED<<h,t>>

Next  ==  \E i \in ProcSet : \/ CoEat(i)
                             \/ CoThink(i)
                             \/ CoHungry(i)
                             \/ Starve(i)
                             \/ TokenKeep(i)

TokenLives(i) ==  (p' \in (ProcSet\{p}))

NextGetsToken(i) == /\ p = i
                    /\ p' = (i+1) % 2

GetsEating(i) == /\ h[i]
                 /\ p = i
                 /\ NxtSt(e,i,TRUE)
                 /\ NxtSt(h,i,FALSE)
                 /\ UNCHANGED<<p,t>>



SPEC == /\ ERange
        /\ AllPhiloIni 
        /\ \A i \in ProcSet: OneState(i)
        /\ \A i \in ProcSet: MutexSt(i)
        /\ [][Next]_<<e,t,h,p>>


Liveness ==  /\ \A i \in ProcSet: WF_<<p>>(NextGetsToken(i))
             /\ \A i \in ProcSet: WF_<<e,h>>(GetsEating(i))

LISPEC == SPEC /\ Liveness

OneEats == \A i,j \in ProcSet: (e[i] /\ e[j]) => (i=j)

EatPliesToken == \A i,j \in ProcSet: e[i] => (p = i)



NoStarvation == \A i \in ProcSet: h[i] ~> e[i]

AllGetToken == \A i \in ProcSet: TRUE ~> p=i

--------------------------------------------------------------
THEOREM  SPEC => []AllPhiloIni
==============================================================
(*----------------------------------------------------------------
(0) quais seriam as condicoes de Liveness
(1) a especificacao acima garante Liveness? Se nao, o que falta? *)

