---------------------- MODULE Philo3 ----------------------
EXTENDS Naturals
VARIABLES e, h, t, p 

CONSTANT ProcSet


Pini == p \in {0,1}
ERange == /\ e \in [{0,1} -> BOOLEAN]
          /\ h \in [{0,1} -> BOOLEAN]
          /\ t \in [{0,1} -> BOOLEAN]


Eini(i) == (e[i] => p=i)
AllPhiloIni == /\ Pini
               /\ Eini(0)
               /\ Eini(1)

OneState(i) == (e[i] \/ h[i] \/ t[i])

MutexSt(i) == \neg \/ (e[i] /\ h[i])
                   \/ (e[i] /\ t[i])
                   \/ (t[i] /\ h[i])
 
NxtSt(s,i,val) == (s' = [s EXCEPT ![i] = val])
 
CoEat(i) == /\ e[i] 
            /\ NxtSt(t,i,TRUE)
            /\ UNCHANGED<<e,h,p>>

CoThink(i) == /\ t[i] 
              /\ NxtSt(h,i,TRUE)
	      /\ UNCHANGED<<e,t,p>>

CoHungry(i) == /\ h[i]
               /\ NxtSt(e,i,TRUE)
               /\ UNCHANGED<<h,t,p>>

Starve(i) == /\ h[i] 
             /\ p # i 
             /\ UNCHANGED<<h[i]>>

TokenKeep(i) ==  /\ (p = i) 
                 /\ NxtSt(e,i,FALSE)
                 /\ UNCHANGED<<p,h,t>>

Next  == \/ CoEat(0)
         \/ CoEat(1)
         \/ CoThink(0)
         \/ CoThink(1)
         \/ CoHungry(0)
         \/ CoHungry(1)
         \/ TokenKeep(0)
         \/ TokenKeep(1)


SPEC == /\ ERange
        /\ AllPhiloIni 
        /\ OneState(0)
        /\ OneState(1)
        /\ MutexSt(0)
        /\ MutexSt(1)
        /\ [][Next]_<<e,t,h,p>>

OneEats == \A i,j \in ProcSet: (e[i] /\ e[j]) => (i=j)

TokenLives == p' = (p+1)%2 

HEats(i) ==  (h[i] /\ (p = i)) => <>(e' = [e EXCEPT ![i] = TRUE])


NoStarvation == h[0] => []<>e[0]
--------------------------------------------------------------
THEOREM  SPEC => []AllPhiloIni
==============================================================
