---------------------- MODULE Philo ----------------------
EXTENDS Naturals
VARIABLES e, h, t, p 
Pini == p \in {0,1}
ERange == /\ e \in [{0,1} -> BOOLEAN]
          /\ h \in [{0,1} -> BOOLEAN]
          /\ t \in [{0,1} -> BOOLEAN]


Eini(i) == (e[i] => p=i)
AllPhiloIni == /\ Pini
               /\ Eini(0)
               /\ Eini(1)

OneState(i) == (e[i] \/ h[i] \/ t[i])

MutexSt(i) == \neg \/ (e[i] /\ h[i])
                   \/ (e[i] /\ t[i])
                   \/ (t[i] /\ h[i])
 
NxtSt(s,i,val) == (s' = [s EXCEPT ![i] = val])
 
CoEat(i) == (e[i] => NxtSt(t,i,TRUE)) 

CoThink(i) == (t[i] => NxtSt(h,i,TRUE))

CoHungry(i) == (h[i] => NxtSt(e,i,TRUE))

Starve(i) == ((h[i] /\ p # i) => UNCHANGED<<h[i]>>)

TokenKeep(i) == ((p = i) => NxtSt(e,i,FALSE))

TokenLives == p' = (p+1)%2 

HEats(i) == ((h[i] /\ p = i)=> <>(e' = [e EXCEPT ![i] = TRUE]))

SPEC == /\ ERange
        /\ AllPhiloIni 
        /\ OneState(0)
        /\ OneState(1)
        /\ MutexSt(0)
        /\ MutexSt(1)
        /\ e[0]
        /\ [][CoEat(0)]_<<t[0]>>
        /\ [][CoEat(1)]_<<t[1]>>
        /\ [][CoThink(0)]_<<h[0]>>
        /\ [][CoThink(1)]_<<h[1]>>
        /\ [][CoHungry(0)]_<<e[0]>>
        /\ [][CoHungry(1)]_<<e[1]>>
        /\ [][TokenKeep(0)]_<<e[0]>>
        /\ [][TokenKeep(1)]_<<e[1]>>
        /\ []<><<TokenLives>>_p 
        /\ []HEats(0)
        /\ []HEats(1)
--------------------------------------------------------------
THEOREM  SPEC => []AllPhiloIni
==============================================================
