---------------------- MODULE Philo5 ----------------------
EXTENDS Naturals, TLC
VARIABLES e, h, t, p 

CONSTANT ProcSet



Pini == p \in {0,1}
ERange == /\ e \in [{0,1} -> BOOLEAN]
          /\ h \in [{0,1} -> BOOLEAN]
          /\ t \in [{0,1} -> BOOLEAN]


Eini(i) == (e[i] => p=i)

AllPhiloIni == /\ Pini
               /\ \A i \in ProcSet: Eini(i)

OneState(i) == (e[i] \/ h[i] \/ t[i])

MutexSt(i) == \neg \/ (e[i] /\ h[i])
                   \/ (e[i] /\ t[i])
                   \/ (t[i] /\ h[i])
 
NxtSt(s,i,val) == (s' = [s EXCEPT ![i] = val])
 
CoEat(i) == /\ e[i] 
            /\ NxtSt(t,i,TRUE)
            /\ UNCHANGED<<e,h,p>> 
            (* /\ Print("Go to Eat",TRUE)*)

CoThink(i) == /\ t[i] 
              /\ NxtSt(h,i,TRUE)
	      /\ UNCHANGED<<e,t,p>> 

CoHungry(i) == /\ h[i]
               /\ NxtSt(e,i,TRUE)
               /\ UNCHANGED<<h,t,p>> 

Starve(i) == /\ h[i] 
             /\ p # i 
             /\ UNCHANGED<<h[i]>>

TokenKeep(i) ==  /\ (p = i) 
                 /\ NxtSt(e,i,FALSE)
                 /\ UNCHANGED<<p,h,t>> 

(* Deadlocked Next *)
Next  == \E i\in ProcSet: /\ CoEat(i)
                          /\ CoThink(i)
                          /\ Starve (i)
                          /\ CoHungry(i)
                          /\ TokenKeep(i)

SPEC == /\ ERange
        /\ AllPhiloIni 
        /\ \A i \in ProcSet: OneState(i)
        /\ \A i \in ProcSet: MutexSt(i)
        /\ [][Next]_<<e,t,h,p>>


OneEats == \A i,j \in ProcSet: (e[i] /\ e[j]) => (i=j)

EatPliesToken == \A i,j \in ProcSet: e[i] => (p = i)

TokenLives == p' = (p+1)%2 

HEats(i) ==  (h[i] /\ (p = i)) => <>(e' = [e EXCEPT ![i] = TRUE])


NoStarvation == h[0] => []<>e[0]
--------------------------------------------------------------
THEOREM  SPEC => []AllPhiloIni
==============================================================
