module Main where 

import ProjRenderTour
import Graphics.UI.GLUT 
import Graphics.Rendering.OpenGL


import System.IO

type TwoDimPoint a = (a,a)


readPoints :: (Read a) => [String] -> IO [TwoDimPoint a]


readPoints xs = isEOF >>= \eof -> if eof
                                  then return (map read (reverse xs))
                                  else getLine >>= \ln -> readPoints (ln:xs)

readIntPts :: [String] -> IO [TwoDimPoint Int]
readIntPts = readPoints


type GLPoint=(GLfloat,GLfloat,GLfloat)

toGLPoint::(TwoDimPoint Int)->GLPoint
toGLPoint (x,y) = (fromIntegral x, fromIntegral y,0.0::GLfloat)

--type GLcorners = (GLdouble,GLdouble,GLdouble,GLdouble,GLdouble,GLdouble)

corners::[TwoDimPoint Int]->GLcorners

corners pts = let maxX = fromIntegral (maximum (map fst pts))
		  minX = fromIntegral (minimum (map fst pts))
		  maxY = fromIntegral (maximum (map snd pts))
		  minY = fromIntegral (minimum (map snd  pts))
	      in (minX-0.1,maxX+0.1,minY-0.1,maxY+0.1,-1.0::GLdouble,1.0::GLdouble)


main = readIntPts [] >>= \pts -> parstart (corners pts) (map toGLPoint pts)


