module ProjRenderTour where
import Graphics.UI.GLUT 
import Graphics.Rendering.OpenGL

parstart cs pts = do
  getArgsAndInitialize
  createAWindow "more points" cs pts
  mainLoop

type GLcorners = (GLdouble,GLdouble,GLdouble,GLdouble,GLdouble,GLdouble)

createAWindow::String->GLcorners->[(GLfloat,GLfloat,GLfloat)]->IO()
createAWindow windowName (xl,xu,yl,yu,zl,zu) pts = do
  createWindow windowName
  displayCallback $= (display pts)
  projection xl xu yl yu zl zu

display pts = do 
  clear [ColorBuffer]
  currentColor $= Color4 1 1 0 1
  renderPoints pts
  flush

makeVertexes = mapM_ (\(x,y,z)->vertex$Vertex3 x y z)

renderPoints = renderAs LineLoop -- Points

renderAs figure ps = renderPrimitive figure (makeVertexes ps)

projection xl xu yl yu zl zu =  do 
  matrixMode $= Projection
  loadIdentity
  ortho xl xu yl yu zl zu
  matrixMode $= Modelview 0

points::[(GLfloat,GLfloat,GLfloat)] = 
         [(0.1,0.6,0) 
         ,(0.2,0.8,0)
         ,(0.3,0.1,0)
         ,(0,0,0)
         ,(0.4,-0.8,0)
         ,(-0.2,-0.8,0)
         ]
