module BTreeTest where

-- module used to BTree

import BTree
import Debug.QuickCheck
import Data.List((\\),nub,sort,intersect)
-- Quicheck properties testing
-- prop_BTreebuild: tests btree construction functions
prop_BTreeBuild xs = 
	let t = btreeFoldr xs
	in classify (null xs) "trivial" $
           classify (length xs > 0 && length xs < 3) "one node" $
           classify (length xs > 2 && (length xs < 6)) "two levels" $
	     ((btreeOK t) && ((nub.sort) xs == (btreeUnfoldr t)))
	where types = xs::[Int]


-- prop_BTreeDelete: tests btree deletion
prop_BTreeDelete xs ys =
	let t = btreeFoldr xs
	    newt = foldl delete t ys
	in collect (length xs,length (intersect xs ys)) $
		((btreeOK newt) && ((foldl delete newt (xs\\ys)) == Leaf))
	where types = (xs::[Int],ys::[Int])

