theory PA = Datatype+Recdef:


datatype Natnum = Z | S Natnum;

consts pred :: "Natnum => Natnum"
       recsum :: "Natnum => Natnum => Natnum"
       itsum :: "Natnum => Natnum => Natnum"
       natsize :: "Natnum => nat"
       gt :: "Natnum * Natnum => bool"
       fib :: "Natnum => Natnum"
       itsub :: "Natnum * Natnum => Natnum"
       recsub :: "Natnum => Natnum => Natnum";


primrec
       "itsum m Z = m"
       "itsum m (S n) = itsum (S m) n";

primrec
       "recsum m Z = m"
       "recsum m (S n) = S(recsum m n)";

primrec
       "natsize Z = 0"
       "natsize (S n) = 1 + (natsize n)";

recdef gt "measure (%(m,n). (natsize n))" 
       "gt(Z,n) = False"
       "gt((S m),Z) = True"
       "gt((S m),(S n)) = gt(m,n)";


recdef fib "measure (%n. (natsize n))"
       "fib Z = Z"
       "fib (S Z) = (S Z)"
       "fib (S (S n)) = recsum (fib (S n)) (fib n)";

recdef itsub "measure (%(m,n). (natsize n))"
       "itsub (m,Z) = m"
       "itsub (Z,n) = Z"
       "itsub ((S m),(S n)) = itsub(m,n)";

primrec 
       "pred Z = Z"
       "pred (S n) = n";

primrec
       "recsub m Z = m"
       "recsub m (S n) = pred(recsub m n)";

lemma recsum_Z_n [simp] : "recsum Z n = n";
apply(induct_tac n);
apply(auto);
done;

lemma recsum_Sm_n [simp]: "recsum (S m) n = S(recsum m n)";
apply(induct_tac n);
apply(auto);
done;

lemma recsum_commutes [simp]: "recsum m n = recsum n m";
apply(induct_tac n);
apply(auto);
done;

lemma itsum_Sm_n [simp]: "ALL m. itsum (S m) n = S(itsum m n)";
apply(induct_tac n);
apply(auto);
done;

lemma itsum_recsum [simp]: "itsum m n = recsum m n";
apply(induct_tac n);
apply(auto);
done;

lemma gt_Z [simp]: "ALL m. gt((S m),Z)";
apply(auto);
done;

lemma gt_Z_itsub [simp]: "EX u. gt(m,Z) --> itsub(m,Z)= (S u)";
apply(case_tac m);
apply(auto);
done;

lemma pred_itsub [simp]: "ALL m. itsub(m,(S n))= pred(itsub(m,n))";
apply(induct_tac n);
apply clarify;
apply(case_tac m);
apply(auto);
apply(case_tac Natnum);
apply(auto);
apply(case_tac m);
apply(auto);
apply(case_tac Natnum);
apply(auto);
apply(drule_tac x="(S Natnuma)" in spec);
apply(auto);
done;

lemma recsub_itsub [simp]: "itsub(m,n)= recsub m n";
apply(induct_tac n);
apply(auto);
apply(case_tac m);
apply(auto);
done;






















































 





