#include<CUnit/CUnit.h>
#include<CUnit/TestDB.h>
#include <CUnit/Curses.h>

int init(void) { return 0;}
int clean(void) { return 0;}

void 
self_consistent_eq(void)
{
  ASSERT(Zeq(Z()));
  ASSERT(eq(Z(),Z()));
  ASSERT(eq(S(S(Z())),S(S(Z)))); // error in this line: Z instead of Z()
  ASSERT(!eq(S(Z()),Z()));
  ASSERT(eq(S(Z()),S(S(Z)))); // same as before
}

void 
self_consistent_sum(void)
{
  ASSERT(eq(itsum(Z(),Z()),Z()));
  ASSERT(eq(itsum(S(S(Z())),S(S(Z))),recsum(S(S(Z())),S(S(Z)))));
}

void
model_consistent_sum(void)
{
  ASSERT(nn2uns(itsum(Z(),Z())) == 0);
  ASSERT(nn2uns(itsum(S(S(Z())),S(S(Z)))) == 
         nn2uns(recsum(S(S(Z())),S(S(Z)))));

}

void runTests(void)
{
  PTestGroup pGroup;
  PTestCase pTest;


  initialize_registry();
  pGroup = add_test_group("Self Consistency", init, clean);
  pTest = add_test_case(pGroup, "Self Test equality", self_consistent_eq);
  //pTest = add_test_case(pGroup, "Self Test sum", self_consistent_sum);

  //pGroup = add_test_group("Model Consistency", init, clean);
  //pTest = add_test_case(pGroup, "Model Test sum", model_consistent_sum);

  curses_run_tests();
  cleanup_registry();
}


int 
main()
{
  
  runTests();
 
  return 0;
}
