{-
 - Save as 
 - 	s0.hs
 - Compile with
 - 	ghc --make s0.hs
 - run with
 - 	./s0 file0 file1
 -
 - Syntax of both file0 and file1
 - 	lines each containing a pair of numbers separated by spaces 
 -
 - 	EXERCISE
 - 	What's this program doing?
 - 	What can you say about the running time and memory consumption if both files have 2 pairs? What if first one 
 - 	has two pairs and the second one has two million pairs?
-}


{-# OPTIONS_GHC -fglasgow-exts #-}
module Main where
import System.Environment


type Point = (Double, Double)

parseDouble :: (ReadS Double) = reads
parseInt :: (ReadS Int) = reads

readInt :: String -> IO Int
readInt = return . fst . head . parseInt

readPoint :: String -> Point

readPoint str =
    let (x, str0) = head . parseDouble $ str
        (y, _) = head . parseDouble $ str0
    in (x,y)

readPoints file = 
    readFile file >>=
    return . lines >>=
    return . map readPoint

dist (x0, y0) (x1, y1) = 
    sqrt $ (x0 - x1)**2.0 + (y0 - y1)**2.0

phi0 pts = foldr (+) 0 . map (\ ((x0,y0), (x1,y1)) -> sqrt $ (x0 - x1)**2.0 + (y0 - y1)**2.0) . zip pts

phi1 pts = foldr (+) 0 . map (uncurry dist) . zip pts

sumDists [] _ = 0
sumDists _ [] = 0
sumDists (p0:pts0) (p1:pts1) = dist p0 p1 + sumDists pts0 pts1

phi2 pts0 pts1 = sumDists pts0 pts1

myfoldl op z xs = foldloop op xs z
	where foldloop op xs acc
		| null xs = acc
		| otherwise = foldloop op (tail xs) $ acc `op` (head xs)

 data Nn =
     Z
   |S Nn
   deriving (Eq, Read, Show)

main =
    getArgs >>= \ args ->
    readPoints (args!!0) >>= \pts0 ->
    readPoints (args!!1) >>= \pts1 ->
    print (phi0 pts0 pts1) >>
    print (phi1 pts0 pts1)  >>
    print (phi2 pts0 pts1)    


